# 帳票設計書 4-Shards Report

## 概要

本ドキュメントは、OpenSearchの `_cat/shards` APIが出力するShards Reportの帳票設計書である。シャードの配置情報をテキストテーブル形式で出力するCat APIエンドポイントの仕様を定義する。

### 本帳票の処理概要

Shards Reportは、クラスタ内の全シャードまたは指定インデックスのシャードについて、配置先ノード、プライマリ/レプリカ区分、状態、ドキュメント数などの情報を一覧表示する帳票である。

**業務上の目的・背景**：シャードの配置状況を把握することで、データの分散状態、未割り当てシャードの検出、リバランスの必要性判断に利用する。シャードレベルでの詳細な統計情報は、パフォーマンス問題の根本原因分析にも不可欠である。

**帳票の利用シーン**：シャード配置の確認、未割り当てシャードの原因調査、シャードレベルのパフォーマンス分析、リカバリ状況の確認、シーケンス番号の確認に利用される。

**主要な出力内容**：
1. シャード識別情報（インデックス名、シャード番号、プライマリ/レプリカ/サーチオンリー、状態）
2. ドキュメント数とストアサイズ
3. 配置先ノード情報（IP、ノードID、ノード名）
4. 未割り当て情報（理由、時刻、詳細）
5. 各種統計（検索、インデキシング、マージ、セグメント、シーケンス番号等）

**帳票の出力タイミング**：ユーザーが `GET /_cat/shards` または `GET /_cat/shards/{index}` エンドポイントにHTTPリクエストを送信した時点で出力される。

**帳票の利用者**：クラスタ管理者、SRE、運用監視チーム。

## 帳票種別

一覧表（テキストテーブル形式のシャード配置情報一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Cat シャード | `GET /_cat/shards` | HTTP GETリクエスト |
| - | Cat シャード（指定） | `GET /_cat/shards/{index}` | HTTP GETリクエスト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（text/plain）/ JSON（application/json） |
| 用紙サイズ | N/A（REST APIレスポンス） |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

## 帳票レイアウト

### 明細部（デフォルト表示カラム）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | index | インデックス名 | ShardRouting.getIndexName() | 文字列 |
| 2 | shard | シャード番号 | ShardRouting.id() | 数値 |
| 3 | prirep | プライマリ/レプリカ | ShardRouting.primary() | p/r/s |
| 4 | state | シャード状態 | ShardRouting.state() | 文字列 |
| 5 | docs | ドキュメント数 | CommonStats.getDocs().getCount() | 右寄せ数値 |
| 6 | store | ストアサイズ | CommonStats.getStore().getSize() | 右寄せバイト値 |
| 7 | ip | ノードIPアドレス | DiscoveryNodes.get(nodeId).getHostAddress() | 文字列 |
| 8 | node | ノード名 | DiscoveryNodes.get(nodeId).getName() | 文字列 |

### 明細部（主要オプションカラム）

- **未割り当て情報**: unassigned.reason, unassigned.at, unassigned.for, unassigned.details
- **リカバリソース**: recoverysource.type
- **シーケンス番号**: seq_no.max, seq_no.local_checkpoint, seq_no.global_checkpoint
- **パス情報**: path.data, path.state
- **各種統計**: completion.size, fielddata, query_cache, flush, get, indexing, merges, refresh, search, segments, warmer

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| index | インデックス名パターン | No |
| local | ローカルクラスタ状態を使用 | No |
| cancel_after_time_interval | タイムアウト設定 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| - | `s` パラメータで任意指定可能 | 任意 |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| データソース | 用途 | 取得方法 |
|-----------|------|---------|
| CatShardsResponse | シャード情報の統合レスポンス | CatShardsAction.INSTANCE 経由 |
| DiscoveryNodes | ノード情報 | CatShardsResponse.getNodes() |
| IndicesStatsResponse | シャード統計 | CatShardsResponse.getIndicesStatsResponse() |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| prirep | primary() ? "p" : isSearchOnly() ? "s" : "r" | なし | サーチオンリーレプリカは "s" |
| unassigned.for | System.currentTimeMillis() - unassignedTimeInMillis | なし | TimeValue で表示 |
| node（リロケーティング時） | "name -> reloIP reloNodeId reloName" | なし | リロケーション先情報を付加 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[GET /_cat/shards リクエスト受信] --> B[doCatRequest]
    B --> C[CatShardsRequest 生成]
    C --> D[CatShardsAction.INSTANCE 実行]
    D --> E[CatShardsResponse 受信]
    E --> F[buildTable でテーブル構築]
    F --> G[RestTable.buildResponse でレスポンス生成]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 未割り当てシャード | シャードがノードに割り当てられていない | ip/id/node がnull表示 | unassigned.reason で原因確認 |
| 統計情報なし | ShardStats がnullの場合 | 各統計カラムがnull表示 | 正常動作（起動中など） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | シャード数分の行（数十～数万） |
| 目標出力時間 | 数百ミリ秒～数秒 |
| 同時出力数上限 | isRequestLimitCheckSupported() が true |

## セキュリティ考慮事項

- `allowSystemIndexAccessByDefault()` が `true` に設定されている。
- シャードのデータパス情報が含まれるため、インフラ情報の漏洩に注意。

## 備考

- RestShardsAction は AbstractListAction を継承しているが、`isActionPaginated()` は `false`。
- CatShardsAction を使用した専用の統合リクエスト/レスポンス構造を持つ。
- `getOrNull` ヘルパーメソッドで null安全な値取得を実現。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RestShardsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestShardsAction.java` | 行149-358: getTableWithHeader() で全カラム定義を確認 |
| 1-2 | CatShardsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/CatShardsResponse.java` | 統合レスポンスのデータ構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestShardsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestShardsAction.java` | 行117-142: doCatRequest() で CatShardsAction 経由の呼び出し |

**主要処理フロー**:
1. **行118-126**: パラメータ解析（index, local, cluster_manager_timeout, cancel_after_time_interval）
2. **行127-141**: CatShardsAction.INSTANCE を実行し、レスポンスから buildTable を呼び出し

#### Step 3: テーブル構築ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestShardsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestShardsAction.java` | 行371-598: buildTable() でシャードごとに行を構築 |

### プログラム呼び出し階層図

```
AbstractListAction.prepareRequest()
    |
    +-- RestShardsAction.doCatRequest() [行117]
           |
           +-- CatShardsAction.INSTANCE 実行 [行127]
           |      |
           |      +-- CatShardsResponse 返却
           |
           +-- buildTable() [行371]
           |      |
           |      +-- getTableWithHeader() [行149]
           |      +-- ShardRouting 反復 [行380]
           |      +-- getOrNull() ヘルパー [行360]
           |
           +-- RestTable.buildResponse()
```

### データフロー図

```
[入力]                        [処理]                         [出力]

GET /_cat/shards      --->  CatShardsAction            --->  テキストテーブル
GET /_cat/shards/{idx}         |                              (シャード数分の行)
                               v
                        CatShardsResponse
                        (DiscoveryNodes + IndicesStatsResponse + ShardRoutings)
                               |
                               v
                        buildTable() で統合 → Table
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestShardsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestShardsAction.java` | ソース | Shards Report メイン処理 |
| CatShardsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/CatShardsAction.java` | ソース | シャード情報取得アクション |
| CatShardsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/CatShardsRequest.java` | ソース | リクエスト |
| CatShardsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/shards/CatShardsResponse.java` | ソース | レスポンス |
| RestShardsActionTests.java | `server/src/test/java/org/opensearch/rest/action/cat/RestShardsActionTests.java` | テスト | ユニットテスト |
